﻿// Получение модифицируемого задания.
var task = ((CardStoreTaskExtensionContext) this.CardContext).Task;

// Получение идентификатора вторичного процесса по идентификатору задания.
var secondaryProcessID = await this.Db.SetCommand(
	this.DbScope.BuilderFactory
		.Select()
			.C("wt", "ProcessRowID")
		.From("WorkflowTasks", "wt").NoLock()
		.Where()
			.C("wt", "RowID").Equals().P("TaskRowID")
		.Build(),
	this.Db.Parameter("TaskRowID", task.RowID))
	.LogCommand()
	.ExecuteAsync<Guid>(this.CancellationToken);

if(secondaryProcessID == Guid.Empty)
{
	this.AddError($"Не найден вторичный процесс для задания с ИД = {task.RowID:B}.");
	return;
}

// Получение значения из хранилища с дополнительной информацией по найденному вторичному процессу.
var processInfo = await this.GetSecondaryProcessInfoAsync(secondaryProcessID);
var comment = processInfo.Get<object>("Comment");

// Установка значения в карточке задания.
task.Card.Sections[KrConstants.KrTask.Name].Fields[KrConstants.KrTask.Comment] = comment;